/*
 * Decompiled with CFR 0.152.
 */
package es.ejie.frmk.presentacion.iu.taglib.html.table.pagination;

import es.ejie.frmk.infraestructura.traza.Q70TraceLevel;
import es.ejie.frmk.infraestructura.traza.Q70Traza;
import es.ejie.frmk.presentacion.iu.taglib.base.Q70Constants;
import es.ejie.frmk.presentacion.iu.taglib.base.Q70CustomTagException;
import es.ejie.frmk.presentacion.iu.taglib.base.Q70TableProperties;
import es.ejie.frmk.presentacion.iu.taglib.html.table.pagination.Q70Pagination;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Q70SmartListHelper {
    private List fullList;
    private int fullListSize;
    private int pageSize;
    private int pageCount;
    private int currentPage;
    private Q70TableProperties properties = null;
    private static Q70Traza traza = Q70Traza.getSingleton();

    public Q70SmartListHelper(List list, int n, Q70TableProperties q70TableProperties) {
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "new Q70SmartListHelper: list.size= " + list.size() + " page size=" + n);
        }
        if (list == null || n < 1) {
            throw new IllegalArgumentException("Bad arguments passed into Q70SmartListHelper() constructor. List=" + list + ", pagesize=" + n);
        }
        this.properties = q70TableProperties;
        this.pageSize = n;
        this.fullList = list;
        this.fullListSize = this.fullList != null ? list.size() : 0;
        this.pageCount = this.computedPageCount();
        this.currentPage = 1;
    }

    protected int computedPageCount() {
        int n = 0;
        if (this.fullList != null && this.pageSize > 0) {
            int n2 = this.fullListSize;
            int n3 = n2 / this.pageSize;
            int n4 = n2 % this.pageSize;
            n = n4 == 0 ? n3 : n3 + 1;
        }
        return n;
    }

    protected int getFirstIndexForCurrentPage() {
        return this.getFirstIndexForPage(this.currentPage);
    }

    protected int getLastIndexForCurrentPage() {
        return this.getLastIndexForPage(this.currentPage);
    }

    protected int getFirstIndexForPage(int n) {
        return (n - 1) * this.pageSize;
    }

    protected int getLastIndexForPage(int n) {
        int n2 = this.getFirstIndexForPage(n);
        int n3 = this.pageSize - 1;
        int n4 = this.fullListSize - 1;
        return Math.min(n2 + n3, n4);
    }

    public List getListForCurrentPage() {
        return this.getListForPage(this.currentPage);
    }

    protected List getListForPage(int n) {
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "getListForPage page=" + n);
        }
        ArrayList arrayList = new ArrayList(this.pageSize + 1);
        int n2 = this.getFirstIndexForPage(n);
        int n3 = this.getLastIndexForPage(n);
        Iterator iterator = this.fullList.iterator();
        int n4 = 0;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (n4 > n3) break;
            if (n4 >= n2) {
                arrayList.add(e);
            }
            ++n4;
        }
        return arrayList;
    }

    public void setCurrentPage(int n) {
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "setCurrentPage: page=" + n + " of " + this.pageCount);
        }
        this.currentPage = n < 1 || n != 1 && n > this.pageCount ? 1 : n;
    }

    public String getSearchResultsSummary() throws Q70CustomTagException {
        if (this.fullListSize == 0) {
            if (traza.isTraceActive()) {
                traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "returning paging.banner.no_items_found");
            }
            Object[] objectArray = new Object[]{this.properties.getPagingItemsName()};
            return MessageFormat.format(this.properties.getPagingFoundNoItems(), objectArray);
        }
        if (this.fullListSize == 1) {
            if (traza.isTraceActive()) {
                traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "returning paging.banner.one_item_found");
            }
            Object[] objectArray = new Object[]{this.properties.getPagingItemName()};
            return MessageFormat.format(this.properties.getPagingFoundOneItem(), objectArray);
        }
        if (this.computedPageCount() == 1) {
            Object[] objectArray = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), this.properties.getPagingItemsName()};
            if (traza.isTraceActive()) {
                traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "returning paging.banner.all_items_found");
            }
            return MessageFormat.format(this.properties.getPagingFoundAllItems(), objectArray);
        }
        Object[] objectArray = new Object[]{new Integer(this.fullListSize), this.properties.getPagingItemsName(), new Integer(this.getFirstIndexForCurrentPage() + 1), new Integer(this.getLastIndexForCurrentPage() + 1)};
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "returning paging.banner.some_items_found");
        }
        return MessageFormat.format(this.properties.getPagingFoundSomeItems(), objectArray);
    }

    public String getPageNavigationBar(String string, boolean bl) throws Q70CustomTagException {
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "getPageNavigationBar");
        }
        int n = 8;
        n = this.properties.getPagingGroupSize(n);
        int n2 = this.currentPage;
        int n3 = this.pageCount;
        int n4 = 1;
        int n5 = n;
        Q70Pagination q70Pagination = new Q70Pagination(string);
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "this.pageCount=" + this.pageCount);
        }
        if (n3 == 0) {
            q70Pagination.addPage(1, true);
        }
        if (n2 < n) {
            n4 = 1;
            n5 = n;
            if (n3 < n5) {
                n5 = n3;
            }
        } else {
            n4 = n2;
            while (n4 + n > n3 + 1) {
                --n4;
            }
            n5 = n4 + (n - 1);
        }
        if (n2 != 1) {
            q70Pagination.setFirst(new Integer(1));
            q70Pagination.setPrevious(new Integer(n2 - 1));
        }
        for (int i = n4; i <= n5; ++i) {
            if (traza.isTraceActive()) {
                traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "adding page " + i);
            }
            q70Pagination.addPage(i, i == n2);
        }
        if (n2 != n3) {
            q70Pagination.setNext(new Integer(n2 + 1));
            q70Pagination.setLast(new Integer(n3));
        }
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "lPagination.isOnePage()=" + q70Pagination.isOnePage());
        }
        String string2 = q70Pagination.isOnePage() ? this.properties.getPagingBannerOnePage() : (q70Pagination.isFirst() ? this.properties.getPagingBannerFirst() : (q70Pagination.isLast() ? this.properties.getPagingBannerLast() : this.properties.getPagingBannerFull()));
        if (traza.isTraceActive()) {
            traza.trace(Q70Constants.COMPONENTE_CUSTOM_TAG, Q70TraceLevel.DEBUG, "getPageNavigationBar end");
        }
        return q70Pagination.getFormattedBanner(this.properties.getPagingPageLink(), this.properties.getPagingPageSelected(), this.properties.getPagingPageSeparator(), string2, bl);
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SIMPLE_STYLE).append("fullList", (Object)this.fullList).append("fullListSize", this.fullListSize).append("pageSize", this.pageSize).append("pageCount", this.pageCount).append("properties", (Object)this.properties).append("currentPage", this.currentPage).toString();
    }
}

